import os
import sys
import numpy as np
from glob import glob
from compute_recall import compute_recall_from_file
import socket

if __name__ == "__main__":
    hostname = socket.gethostname()
    stride = 1
    IMU_poseinit_after =  20 #15
    output_folder = f"/home/zihzhu/data/output_euroc/code_release_test3_stride{stride}"
    config_file = "config/euroc.yaml"
    
    if hostname == 'zihzhu':
        seqs = sorted(glob('/home/zihzhu/data/Datasets/euroc/*'))
    else:
        seqs = sorted(glob('/cluster/project/cvg/zihzhu/Datasets/euroc/*'))
    # traj_name='traj_kf_afterBA.txt'
    # traj_name='traj_full_afterBA.txt'
    # traj_name='traj_full_beforeBA.txt'
    traj_name='traj_kf_beforeBA.txt'
    output_folder_type=output_folder.split('/')[-1]
    os.makedirs(os.path.join(output_folder, 'pcs'), exist_ok=True)
    print(output_folder)
    excel=''
    excel_scale=''
    excel_gt_coverage=''
    excel_input_coverage=''
    excel_recall=''
    
    ate_values = []
    scale_errors = []
    gt_coverages = []
    input_coverages = []
    recalls = []
    for i, seq in enumerate(seqs[:]):
        if 'stride' in seq:
            continue
        name = os.path.basename(seq)
        
        os.makedirs(os.path.join(output_folder, name), exist_ok=True)
        print("##################################  Processing: {}  ##################################".format(seq))
        # run hislam2
        cmd = f'python demo.py --calib calib/euroc.txt \
                --imagedir {seq}/mav0/cam0/data \
                --config {config_file} \
                --stride {stride} \
                --IMU_poseinit_after {IMU_poseinit_after} \
                --imufile {seq}/mav0/imu0/data.csv --output {output_folder}/{name} \
                --undistort > {output_folder}/{name}/log.txt'  # --final_ba_inertial \
        if not os.path.exists(f'{output_folder}/{name}/{traj_name}'):
            print(cmd)
            os.system(cmd)
            
            # os.system(f"sbatch --time=4:00:00 -A ls_polle -n 1  --cpus-per-task=16 --mem-per-cpu=10G  --gpus=1 --gres=gpumem:20g  --output=slurms/{output_folder_type}_{name}.out  --wrap '{cmd}'")
            # continue

        gt_file = f'euroc_groundtruth/{name}_sec.txt'
        cmd = f'evo_ape tum -vas --no_warnings --plot_mode xy --save_plot {output_folder}/{name}/ape_se3.png --save_results {output_folder}/{name}/ape_results.zip \
            {gt_file} {output_folder}/{name}/{traj_name} > {output_folder}/{name}/log_ape.txt'
        print(cmd)
        if True or (not os.path.exists(f'{output_folder}/{name}/ape_se3_map.png')):
            os.system(cmd)

        ATE = float([l for l in open(f'{output_folder}/{name}/log_ape.txt').readlines() if 'rmse' in l][-1].split('\t')[-1])
        scale = float([l for l in open(f'{output_folder}/{name}/log_ape.txt').readlines() if 'Scale correction' in l][-1].split(' ')[-1])
        
        ATE_cm = ATE * 100
        scale_err_percent = abs(1 - scale) * 100
        _, __, recall = compute_recall_from_file(f'{gt_file}', f'{output_folder}/{name}/{traj_name}')
        print(f'Recall: {recall:.2f}%')
        ate_values.append(ATE_cm)
        scale_errors.append(scale_err_percent)
        recalls.append(recall)

        excel=excel+' ,'+str(ATE_cm)
        excel_scale=excel_scale+' ,'+str(scale_err_percent)
        excel_recall=excel_recall+' ,'+str(recall)
        print(f'APE before: {ATE:.4f}, scale: {scale:.4f}, Rel. scale error: {abs(1-scale):.4f}')
    print(excel)
    print(excel_scale)
    print(excel_recall)
    
    
    # Build LaTeX lines
    ate_line = "ATE [cm] & " + " & ".join(f"{v:.2f}" for v in ate_values) + f" & {np.mean(ate_values):.2f} \\\\"
    scale_line = "Scale error [\\%] & " + " & ".join(f"{v:.2f}" for v in scale_errors) + f" & {np.mean(scale_errors):.2f} \\\\"
    recall_line = "Ours Recall [\\%] & " + " & ".join(f"{v:.2f}" for v in recalls) + f" & {np.mean(recalls):.2f} \\\\"

    # Print
    print(ate_line)
    print(scale_line)
    print(recall_line)